//g++ -O4 -march=core2 -mfpmath=sse -g0 -DNDEBUG -finline-functions -S gc2009.meta.cpp

//Copy-past from article
#include <iostream> 
#include <boost/numeric/ublas/matrix.hpp>
namespace gc2009
{
  class NullType {};
  template<int v>  struct Int2Type 
    { enum { value = v }; };

  template<int i,class T=NullType>
  struct IndexList {
    enum {value=i};
    typedef T Next;
  };
namespace IL 
{

template<int i>  
class  ERROR__in_IndexList_usage 
{
    enum Error {Index_out_of_range=i};
};


  template<int i,int n>
  struct MakeInRange
  {
    typedef IndexList<i,typename 
	MakeInRange<i+1,n>::Result > Result;
  };
  template<int n>
  struct MakeInRange<n,n>
  {
    typedef NullType Result;
  };

  template<int i,class IList=NullType>	 
  struct PushBack;
  template<int i>                   
  struct PushBack<i,NullType >
  {
    typedef IndexList<i,NullType> Result;
  };
  template<int i,int j,class Tail>
  struct PushBack<i,IndexList<j,Tail> >
  {  
    typedef IndexList<j,typename 
    PushBack<i,Tail>::Result > Result;
  };
  template<class IList> struct Length;
  template<> struct Length<NullType>
  {  enum {value=0}; };
  template<int i,class T> 
  struct Length<IndexList<i,T> >
  { enum { value=1+Length<T>::value };};
  
  template<int i,class IList> struct Elem;
  
  template<int j,class T>
  struct Elem<0,IndexList<j,T> >
  { enum { value=j }; };

  template<int i,int j,class T> 
  struct Elem<i,IndexList<j,T> >
  { enum { value=Elem<i-1,T>::value }; };
  
  template<int i> struct Elem<i,NullType >
  { enum { value = ERROR__in_IndexList_usage<i>::Index_out_of_range };
  };

  template<int i,class IList> 
  struct EraseAt;
  template<int i> 
  struct EraseAt<i,NullType >
  { 
	enum { value = ERROR__in_IndexList_usage<i>::Index_out_of_range  };
	typedef NullType Result;
  };
  template<int j,class T> 
  struct EraseAt<0,IndexList<j,T> >
  {  typedef T Result; };
  template<int i,int j,class T> 
  struct EraseAt<i,IndexList<j,T> >
  {
    typedef IndexList<j,typename 
    EraseAt<i-1,T>::Result> Result;
  };
}

  template<class IList1,class IList2,
            int isOdd,int k,int i> 
 struct permut
 {
  enum { value=IL::Elem<i,IList2>::value };
  typedef typename 
        IL::EraseAt<i,IList2>::Result Tail;
  typedef typename 
   IL::PushBack<value,IList1>::Result Head;
  enum { is_Odd = (1&(isOdd+i)) };
  
  template<class Func>
  static void forEach(Func& f)
  {
    permut<IList1,IList2,isOdd,
    IL::Length<IList2>::value,i+1>
      ::forEach(f);

    permut<Head,Tail,is_Odd,
    IL::Length<Tail>::value,0>::forEach(f);
  }
 };
 template<class IList1,class IList2,
              int isOdd,int k> 
 struct permut<IList1,IList2,isOdd,k,k > 
 {
    template<class Func>
    static void forEach(Func& f) {}
 };


 template<class IList1,int isOdd> 
 struct permut<IList1,NullType,isOdd,0,0> 
 {
    template<class Func>
    static void forEach(Func& f)
    { f.template f<isOdd,IList1>(); }
 };
 template<int N,class Func>
 inline void ForEachPermutation(Func& f)
 {
    typedef typename IL::MakeInRange<0,N>
		::Result IList;
    permut<NullType,IList,0,N,0>
		::forEach(f);
 }

 
 template<int isSubtract,typename T>
  void AddOrSub(T& result,T value)
  {
     AddOrSub(result,value,
          Int2Type<(isSubtract?1:0)>() );
  }
  template<typename T>
  void AddOrSub(T& result,
            T value,Int2Type<1> )
     { result-=value; }
  template<typename T>
  void AddOrSub(T& result,
            T value,Int2Type<0> )
     { result+=value; }

template<class Matrix>
class det
{
  typedef typename Matrix::value_type 
                      value_type;
  const Matrix& A;
  
  template<class Il,int i>
  value_type a()
  {
    return A(i,IL::Elem<i,Il>::value);
  }
  template<class Il,int i> 
  value_type mul(Int2Type<i>  )
  {
    return a<Il,i>()
         *mul<Il,i-1>(Int2Type<i-1>());
  }
  template<class Il,int i> 
  value_type mul(Int2Type<0> )
  { return a<Il,i>(); }
public:
  value_type result;
  det(const Matrix& mat)
     : A(mat) , result(0) {}
  template<int isOdd,class IList>
  void f()
  {
    enum {last=IL::Length<IList>::value-1};
    AddOrSub<isOdd>(result,
     mul<IList,last>(Int2Type<last>()) );
  }
};


 template<int N,typename T,typename TT>
 void set(T* dst,TT value)
 { set(dst,T(value),Int2Type<N>()); }
 template<typename T,int N>
 void set(T* dst,T value,Int2Type<N>)
 {
    *dst=value;
    set(dst+1,value,Int2Type<N-1>());
 }
 template<typename T>
 void set(T* dst,T value,Int2Type<0>) {}


  template<unsigned n> 
 struct BitsIn
 {
 enum { temp=(n/2)+BitsIn<(n/2)>::temp };
 enum { value=n-unsigned(temp) };
 };
 template<> 
 struct BitsIn<0>
 {
 enum { temp=0 };
 enum { value=0 };
 };

 template<class Matrix,int N>
 class det_poly_coef
 {
   typedef typename Matrix::value_type T;
   const Matrix& A;
   const Matrix& B;
   enum { mask = (1<<N)-1 };

   template<class Il,int i>
   T ab(Int2Type<0> )
   { return A(i,IL::Elem<i,Il>::value);}
   template<class Il,int i>
   T ab(Int2Type<1> )
   { return B(i,IL::Elem<i,Il>::value); }
   template<class Il,int i,int is_b>
   T ab()
   { return ab<Il,i>(Int2Type<is_b>()); }

   template<class Il,int i,int m> 
   T mul(Int2Type<i> )
   {
     enum { m2 = m/2 };
     return ab<Il,i,m&1>() * mul<Il,
          (i-1),m2>( Int2Type<(i-1)>() );
   }
   template<class Il,int i,int m> 
   T mul(Int2Type<0> )
   { return ab<Il,i,m&1>(); }

   template<int m,int isOdd,class IList>
   void one_comp()
   {
    enum {last=IL::Length<IList>::value-1};
    AddOrSub<isOdd>(
      coef[BitsIn<m>::value] ,
      mul<IList,last,m>(
         Int2Type<last>()) );
   }
   template<int m,int isOdd,class IList>
   void comp(Int2Type<1> )
   {
     one_comp<m,isOdd,IList>();
     comp<m-1,isOdd,IList>(
          Int2Type<((m-1)?1:0)>());
   }
   template<int m,int isOdd,class IList>
   void comp(Int2Type<0> )
   {
     one_comp<m,isOdd,IList>();
   }

 public:
   T coef[N+1];
   det_poly_coef(const Matrix& A_,
        const Matrix& B_): A(A_), B(B_) 
   { set<N+1>(coef,0); }

   template<int isOdd,class IList>
   void f()
   {comp<mask,isOdd,IList>(Int2Type<1>());}
};

}//namespace gc2009

int main(int argc,char* argv[])
{
	using namespace gc2009;
 using namespace boost::numeric::ublas;
 using namespace std;
 {
 enum { N=2 };
 typedef c_matrix<float,N,N> Matrix;
 Matrix a;
 a(0,0)=5.0f;  a(0,1)=13.0f;
 a(1,0)=11.0f; a(1,1)=7.0f;
 det<Matrix> d(a);
 ForEachPermutation<N>(d);
 cout <<" det="<< d.result << endl;
 }
 {
   const int N=3;
  typedef c_matrix<float,N,N> Matrix;
  Matrix a;
  a(0,0)=9.0f; a(0,1)=8.0f; a(0,2)=4.0f;
  a(1,0)=7.0f; a(1,1)=1.0f; a(1,2)=3.0f;
  a(2,0)=5.0f; a(2,1)=3.0f; a(2,2)=6.0f;
  Matrix b;
  b(0,0)=1.0f; b(0,1)=2.0f; b(0,2)=3.0f;
  b(1,0)=4.0f; b(1,1)=5.0f; b(1,2)=6.0f;
  b(2,0)=7.0f; b(2,1)=8.0f; b(2,2)=0.0f;
  det_poly_coef<Matrix,N> d(a,b);
  ForEachPermutation<N>(d);
  cout << "coef= { " ;
  for(int i=0; i<=N; ++i)
    cout << "  " << d.coef[i];
  cout << " }" << endl;

  typedef IL::MakeInRange<0,N>::Result IList;
    std::cout << IL::Elem<2,IList>::value << std::endl;// In bounds, OK
	///--- Next 2 lines results in out of bounds access to IndexList and generates compile time error.
	///--- Uncomment these lines to see error processing.
    //std::cout << IL::Elem<4,IList>::value << std::endl;// Out of bounds, ERROR
    //std::cout << IL::Elem<-2,IList>::value << std::endl;// Out of bounds, ERROR
 
}

	return 0;
}
